% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package_options.R
\name{ShinyItemAnalysis_options}
\alias{ShinyItemAnalysis_options}
\title{Options consulted by ShinyItemAnalysis}
\description{
The package and interactive \code{{shiny}} app consult several options that you
can easily set via \code{\link[=options]{options()}}. Moreover, there is some behavior that can be
changed through environment variables.
}
\section{Options}{
Options are set with \verb{options(<option> = <value>)}.
\itemize{
\item \code{sia.disable_modules}: You can completely disable SIA modules by setting
this to \code{TRUE}.
\item \code{sia.modules_repo}: This is the URL for a CRAN-like repository that the app
uses to retrieve information about available module packages.
\item \code{sia.offer_modules}: If set to \code{TRUE} (the default), calling \code{run_app()}
will check for the available SIA modules at the official repository and offer
to install those module packages that are not installed yet.
}
}

\section{Environment variables}{
You can set this variable system-wide or use \code{R} or project-wise \code{.Renviron}
file. For more details, please navigate to \link[=Startup]{the R documentation}.
\itemize{
\item \code{SIA_MODULES_DEBUG}: Setting this to \code{TRUE} provides a verbose description
of SIA modules-related processes. Useful only for debugging purposes.
}
}

