% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{SetFragments}
\alias{SetFragments}
\title{Set the fragments file path for creating plots}
\usage{
SetFragments(object, file, assay = NULL)
}
\arguments{
\item{object}{A Seurat object}

\item{file}{Path to indexed fragment file.
See \url{https://support.10xgenomics.com/single-cell-atac/software/pipelines/latest/output/fragments}}

\item{assay}{Assay used to generate the fragments.
If NULL, use the active assay.}
}
\value{
Returns a Seurat object
}
\description{
Give path of indexed fragments file that goes with data in the object.
Checks for a valid path and an index file with the same name (.tbi) at the
same path. Stores the path under the tools slot for access by visualization
functions. One fragments file can be stored for each assay.
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
SetFragments(object = atac_small, file = fpath)
}
