% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewBEVAsyLogisticCopula.R
\name{NewBEVAsyLogisticCopula}
\alias{NewBEVAsyLogisticCopula}
\title{Creates a bivariate asymmetric logistic model extreme value copula}
\usage{
NewBEVAsyLogisticCopula(r, theta, phi)
}
\arguments{
\item{r}{real.}

\item{theta}{real.}

\item{phi}{real.}
}
\value{
A function that evaluates the bivariate asymmetric logistic model EV copula (with parameters \eqn{r}, \eqn{\theta} and \eqn{phi}) at a given \eqn{2}-dimensional vector in the unit square.  The environment of the function also contains a function called \code{pdfCopula} that evaluates the probability density function of the bivariate asymmetric mixed model EV copula via automatic differentation.
}
\description{
Creates an instance of the bivariate asymmetric logistic model extreme value copula with parameters \eqn{r}, \eqn{\theta} and \eqn{\phi}.
}
\details{
The dependence function for this bivariate EV copula is \deqn{A(w) = (\theta (1-w)^r + (\phi w)^r)^{1/r} + (\theta - \phi) w + 1 - \theta}
Necessary and sufficient conditions for the dependence function to be valid are
\itemize{
  \item \eqn{r \ge 1}
  \item \eqn{0 \le \theta \le 0}
  \item \eqn{0 \le \phi \le 1}
}
For \eqn{\theta = \phi = 1} this model reduces to the symmetric logistic model.
}
\seealso{
\code{\link{NewBEVLogisticCopula}}, \code{\link{NewMEVAsyLogisticCopula}}
}
\author{
Berwin A. Turlach <berwin.turlach@gmail.com>
}
\keyword{distribution}
