% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewMEVAsyLogisticCopula.R
\name{NewMEVAsyLogisticCopula}
\alias{NewMEVAsyLogisticCopula}
\title{Creates a multivariate asymmetric logistic copula}
\usage{
NewMEVAsyLogisticCopula(theta, r)
}
\arguments{
\item{theta}{a \eqn{k \times d}{k x d} matrix of reals.}

\item{r}{a vector of \eqn{k} reals}
}
\value{
A function that evaluates the multivariate asymmetric logistic copula (with parameters \eqn{\theta} and r) at a given \eqn{d}-dimensional vector in the unit square.  Note that for this function the dimension of vectors at which the copula can be evaluated is determined by the input parameters.  The environment of the function also contains a function called \code{pdfCopula} that evaluates the probability density function of the multivariate asymmetric logistic copula via automatic differentation.
}
\description{
Creates an instance of the multivariate asymmetric copula with parameters \eqn{\theta} and r.
}
\details{
If \code{theta} has entries \eqn{\theta_{ij}} and \code{r} has entries \eqn{r_j} (\eqn{i=1,\dots,k} and \eqn{j=1,\dots,d}), then the following parameterisation of the copula is used:
\deqn{C(u_1,\dots,u_d) = \exp\left(- \sum_{i=1}^k \left\{ \sum_{j=1}^d (\theta_{ij} \bar u_j)^{r_i} \right\}^{1/r_i}  \right)}{C(u_1,\dots,u_d) = exp(- \sum_i { \sum_j (\theta_{ij} v_j)^{r_i} }^{1/r_i} )}
where \eqn{\bar u_j = -\log(u_j)}{v_j = -log(u_j)}, \eqn{j=1,\dots,d}.

Necessary and sufficient conditions for the parameters are
\itemize{
  \item all entries in \code{theta} have to be non-negative.
  \item each column of \code{theta} has to add to one.
  \item each row of \code{theta} must have a unique pattern of non-zero values, including the pattern that has no zeros in a row.
  \item if a row of \code{theta} has only one non-zero value, then the corresponding entry in \code{r} has to be one.
  \item if a row of \code{theta} has more than one non-zero value, then the corresponding entry of \code{r} must be greater than one.
}
}
\examples{
theta <-  rbind(c(0, 0.2, 0.8), c(1,0.8,0.2))
r <- c(2,3)
cop <- NewMEVAsyLogisticCopula(theta, r)

## Creates the same copula
theta <- 0.2
phi <- 0.4
r <- 2
cop1 <- NewBEVAsyLogisticCopula(r, theta, phi)
theta <- cbind(c(phi, 1-phi, 0), c(theta, 0, 1-theta))
r <- c(r, 1,  1)
cop2 <- NewMEVAsyLogisticCopula(theta, r)

}
\seealso{
\code{\link{NewBEVAsyLogisticCopula}}, \code{\link{NewMEVGumbelCopula}}
}
\author{
Berwin A. Turlach <berwin.turlach@gmail.com>
}
\keyword{distribution}
