mc.correlation <-
function(R.mc=10000,cor.matrix,distr="logistic",R.norm=1000)
{
 if(R.mc<1) stop ("'R.mc' must be integer greater than or equal to one")
 R.mc <- as.integer(R.mc)
 if(!is.numeric(cor.matrix))  
    stop("'cor.matrix' must be numeric")
 cor.matrix <- as.matrix(cor.matrix)
 if(!isSymmetric(cor.matrix)) 
    stop("'cor.matrix' must be symmetric") 
 if(any(diag(cor.matrix)!=1)) 
    stop("the diagonal elements of 'cor.matrix' must be one")
 if(any(cor.matrix>1) | any(cor.matrix< -1))
    stop("all the elements of 'cor.matrix' must be on [-1,1]")
 if(any(eigen(cor.matrix,symmetric=TRUE,only.values=TRUE)$values<0))
    stop("'cor.matrix' must be semi-positive definite")
 distrs <- c("logistic","extreme")
  if(!is.element(distr,distrs)) 
   stop("'distr' must be either 'logistic' or 'extreme'") 
 if(R.norm<=1) stop ("'R.norm' must be integer greater than one")
 R.norm <- as.integer(R.norm)
 cor.normal <- cor.marginal <- diag(0,nrow(cor.matrix)) 
 for(i in 1:R.mc) {
 Y.norm <- rmvnorm(R.norm,sigma=cor.matrix)
 Y.marg <- 
   if(distr=="logistic") qlogis(pnorm(Y.norm)) else qgumbel(pnorm(Y.norm))
 cor.normal <- cor.normal + cor(Y.norm)
 cor.marginal <- cor.marginal + cor(Y.marg)
                   }
 list(target.normal=cor.matrix,
      mc.normal=cor.normal/R.mc,
      mc.marginal=cor.marginal/R.mc,
      pd.marginal=all(eigen(cor.marginal/R.mc)$values>=0))
 }

