\name{SimCorMultRes-package}
\alias{SimCorMultRes-package}
\alias{SimCorMultRes}
\docType{package}
\title{
Simulating Correlated Multinomial Responses
}
\description{
Functions to simulate correlated multinomial responses under thresholds. The thresholds give rise either to marginal cumulative link models or to the marginal baseline category logit model. The correlation structure refers to the correlation matrix of the underlying latent variables.
}
\details{
Marginal cumulative link models and marginal baseline category logit models for correlated multinomial responses exist in the literature. This package simulates correlated multinomial responses when the univariate marginals are defined from these models.
For nominal responses, an extension of the principle of maximum random utility is used. For ordinal variables, the responses are produced by chopping off correlated continuous variables. For more details see the references.
}
\author{
Anestis Touloumis <anestis@stat.ufl.edu>

Maintainer: Anestis Touloumis <anestis@stat.ufl.edu>
}
\references{
To do.
}
\keyword{ package }
\examples{
\dontrun{
Simulating correlated ordinal clustered multinomial responses
of cluster size two under a marginal cumulative probit model 
with a linear predictor following a bivariate standard normal 
distribution with correlation=0.8. The cutpoints are -1.5 and 
1.5 and the correlation of the undelying multivariate normal 
distribution is 0.5.
}
rmar.cumlink(clsize=2,lin.pred=rmvnorm(20,sigma=toeplitz(c(1,0.8))),
             cuts=c(-Inf,-1.5,1.5,Inf),cor.matrix=toeplitz(c(1,0.5)))

\dontrun{
Generating correlated multinomial responses under a marginal
baseline category logit model
}
rmar.bcl(clsize=3,ncategories=4,lin.pred=rmvnorm(10,sigma=diag(1,12)),cor.matrix=0.3)
}
