% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Summarise}
\alias{Summarise}
\title{Summarise simulated data using various population comparison statistics}
\usage{
Summarise(condition, results, fixed_objects = NULL)
}
\arguments{
\item{condition}{a single row from the \code{design} input from \code{\link{runSimulation}}
(as a \code{data.frame}), indicating the simulation conditions}

\item{results}{a \code{data.frame} (if \code{Analyse} returned a named numeric vector of any
length), a vector (if \code{Analyse} returned a single unnamed numeric value), or a \code{list}
(if \code{Analyse} returned a \code{list} or multi-rowed \code{data.frame}) containing the analysis
results from \code{\link{Analyse}},
where each cell is stored in a unique row/list element}

\item{fixed_objects}{object passed down from \code{\link{runSimulation}}}
}
\value{
must return a named \code{numeric} vector or \code{data.frame}
  with the desired meta-simulation results
}
\description{
This collapses the simulation results within each condition to composite
estimates such as RMSE, bias, Type I error rates, coverage rates, etc. See the
\code{See Also} section below for useful functions to be used within \code{Summarise}.
}
\examples{
\dontrun{

summarise <- function(condition, results, fixed_objects = NULL) {

    #find results of interest here (alpha < .1, .05, .01)
    lessthan.05 <- EDR(results, alpha = .05)

    # return the results that will be appended to the design input
    ret <- c(lessthan.05=lessthan.05)
    ret
}

}

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{bias}}, \code{\link{RMSE}}, \code{\link{RE}}, \code{\link{EDR}},
  \code{\link{ECR}}, \code{\link{MAE}}
}
