% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_complex.R
\name{get_complex}
\alias{get_complex}
\title{Access internal simulation variables}
\usage{
get_complex(sim, sim_uid)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}}

\item{sim_uid}{The unique identifier of a single simulation replicate. This
corresponds to the \code{sim_uid} column in \code{sim$results}.}
}
\value{
The value of the complex simulation result data corresponding to the
    supplied \code{sim_uid}
}
\description{
Extract complex simulation data from a simulation object
}
\examples{
sim <- new_sim()
create_data <- function(n) {
  x <- runif(n)
  y <- 3 + 2*x + rnorm(n)
  return(data.frame("x"=x, "y"=y))
}
sim \%<>\% set_levels("n"=c(10, 100, 1000))
sim \%<>\% set_config(num_sim=1)
sim \%<>\% set_script(function() {
  dat <- create_data(L$n)
  model <- lm(y~x, data=dat)
  return (list(
    "beta1_hat" = model$coefficients[[2]],
    ".complex" = model
  ))
})
sim \%<>\% run()
sim$results \%>\% print()
get_complex(sim, 1) \%>\% print()
}
