% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run}
\alias{run}
\title{Run the simulation}
\usage{
run(sim)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
\code{\link{new_sim}}}
}
\value{
The original simulation object but with the results attached (along
    with any errors and warnings). Results are stored in \code{sim$results},
    errors are stored in \code{sim$errors}, and warnings are stored in
    \code{sim$warnings}.
}
\description{
This is the workhorse function of \pkg{SimEngine} that actually
    runs the simulation. This should be called after all functions that set
    up the simulation (\code{set_config}, \code{set_script}, etc.) have been
    called.
}
\examples{
# The following is a toy example of a simulation, illustrating the use of
# the run function.
sim <- new_sim()
create_data <- function(n) { rpois(n, lambda=5) }
est_mean <- function(dat, type) {
  if (type=="M") { return(mean(dat)) }
  if (type=="V") { return(var(dat)) }
}
sim \%<>\% set_levels(n=c(10,100,1000), est=c("M","V"))
sim \%<>\% set_config(num_sim=1)
sim \%<>\% set_script(function() {
  dat <- create_data(L$n)
  lambda_hat <- est_mean(dat=dat, type=L$est)
  return (list("lambda_hat"=lambda_hat))
})
sim \%<>\% run()
sim$results \%>\% print()
}
