% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_th.R
\name{predict_th}
\alias{predict_th}
\title{Prediction of theoretical equilibrium}
\usage{
predict_th(A_fun,correl_fun,B_fun=NULL)
}
\arguments{
\item{A_fun}{Numeric vector of activities}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{B_fun}{Numeric vector of global co-regulation coefficients}
}
\value{
List of two elements:
\itemize{
\item \code{$pred_e}: numeric vector of relative concentrations at theoretical equilibrium. Same length as \code{A_fun}
\item \code{$pred_r}: numeric vector of response coefficients at theoretical equilibrium. Same length as \code{A_fun}
}
}
\description{
Gives the theoretical equilibrium for relative concentrations
}
\details{
Gives values at theoretical equilibrium for relative concentrations and response coefficients.
This equilibrium corresponds to null derivative for relative concentrations, without conditions on flux.

When there are regulation groups, preferably use \code{\link{predict_grp}}.
}
\section{Special results}{

In case of negative regulation (\code{correl_fun} = \code{"RegNeg"} or \code{"CRNeg"}), relative concentrations would be negative.

In case of competition plus regulation (\code{correl_fun} = \code{"CRPos"} or \code{"CRNeg"}), response coefficients is not defined and \code{$pred_r} returns \code{NaN}.
}

\examples{
#### For independancy "SC" or competition "Comp"
A <- c(1,10,30)

eq_th <- predict_th(A,"SC")

eq_th$pred_e
eq_th$pred_r

###### In presence of regulation
A <- c(1,10,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
B <- apply(beta,1,sumbis) 

eq_th <- predict_th(A,"CRPos",B)

eq_th$pred_e
eq_th$pred_r


}
\seealso{
Use function \code{\link{activities}} to compute enzyme activities.

Use function \code{\link{is.correl.authorized}} to see allowed constraints for \code{correl_fun}.

Use function \code{\link{predict_grp}} to predict equilibria when there are regulation groups.
}
