% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumbis.R
\name{sumbis}
\alias{sumbis}
\title{Sum of vector elements}
\usage{
sumbis(v)
}
\arguments{
\item{v}{Numeric vector}
}
\value{
Numeric corresponding to the sum of all values present in the input vector
}
\description{
\code{sumbis} computes the sum of a vector
}
\details{
\code{sumbis} computes the sum of a vector,
    to avoid some problems in comparison test due to R \code{\link{sum}} function.

This problem can also be avoided by using \code{all.equal} rather than \code{all} for example.

\code{sumbis} is used for compute global co-regulation coefficients in \code{\link{compute.B.from.beta}}.
}
\examples{
  # Computation of co-regulation coefficients
#Number of enzymes
n <- 3
#Matrix of co-regulations (n column and n rows)
beta<-matrix(rep(0,n*n),nrow=n)
#Vector of global co-regulation coefficients (length n)
B <- rep(0,n)

#For each enzyme
for (j in 1:n){
  beta[j,j]<-1
}

#Set of co-regulation coefficients
beta[1,2]<- 0.1
beta[2,3]<- 2.0 #-0.43
beta[1,3]<- beta[1,2]*beta[2,3]
beta[2,1]<- 1/beta[1,2]
beta[3,1]<- 1/beta[1,3]
beta[3,2]<- 1/beta[2,3]

#Computation of global co-regulation coefficients
for (j in 1:n){
  B[j]<-sumbis(beta[j,])
}
#or
apply(beta,1,sumbis)

# result : B = c(1.3, 13.0,  6.5)

}
