% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/separate_rho.R
\name{separate_rho}
\alias{separate_rho}
\title{Separate Target Correlation Matrix by Variable Type}
\usage{
separate_rho(k_cat, k_cont, k_pois, k_nb, rho)
}
\arguments{
\item{k_cat}{the number of ordinal (r >= 2 categories) variables}

\item{k_cont}{the number of continuous variables}

\item{k_pois}{the number of Poisson variables}

\item{k_nb}{the number of Negative Binomial variables}

\item{rho}{the target correlation matrix}
}
\value{
a list containing the target correlation matrix components by variable combination
}
\description{
This function separates the target correlation matrix rho by variable type (ordinal, continuous, Poisson, and/or
    Negative Binomial).  The function is used in \code{\link[SimMultiCorrData]{findintercorr}},
    \code{\link[SimMultiCorrData]{rcorrvar}}, \code{\link[SimMultiCorrData]{findintercorr2}}, and
    \code{\link[SimMultiCorrData]{rcorrvar2}}.  This would not ordinarily be called directly by the user.
}
\seealso{
\code{\link[SimMultiCorrData]{findintercorr}}, \code{\link[SimMultiCorrData]{rcorrvar}},
    \code{\link[SimMultiCorrData]{findintercorr2}}, \code{\link[SimMultiCorrData]{rcorrvar2}}
}
