% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EXmuts.R
\docType{data}
\name{EXmuts}
\alias{EXmuts}
\title{Example Mutations dataset}
\format{A data set with 500 rows and 6 variables:
\describe{
  \item{colID}{Numeric. The corresponding column number of the SVN in the \code{EXhaps} dataset.}
  \item{chrom}{Numeric. The chromosome number.}
  \item{position}{Numeric. The location of the SNV on the chromosome, in base pairs.}
  \item{afreq}{Numeric. The derived allele frequency of the SNV.}
  \item{marker}{Character. The names of the genes contained in the combined exon.}
  \item{pathwaySNV}{Logical. Indicates if the SNV is located within the pathway.}
}}
\usage{
EXmuts
}
\description{
This data set catalogs the 500 single-nucleotide variants contained in the \code{EXhaps} dataset.  This dataset is intended to accompany the \code{EXhaps} dataset; each row of \code{EXmuts} describes a column (i.e. SNV) in \code{EXhaps}.
}
\details{
Together, the \code{EXmuts} and \code{EXhaps} datasets represent example output of the \code{SNVdata} object returned by the \code{read_slim} function.  The \code{EXhaps} data set represents the sparse matrix \code{Haplotypes} returned by \code{read_slim}, and the \code{EXmuts} data set represents the \code{Mutations} data frame returned by \code{read_slim}.  This toy data set, used primarily for demonstration, contains 50 SNVs which were randomly sampled from genes in the apoptosis sub-pathway, and 450 SNVs sampled from outside the pathway.
}
\seealso{
\code{\link{EXhaps}}, \code{\link{read_slim}}
}
\keyword{datasets}
