% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_survey.R
\name{sim_sets}
\alias{sim_sets}
\title{Simulate survey sets}
\usage{
sim_sets(
  sim,
  subset_cells,
  n_sims = 1,
  trawl_dim = c(1.5, 0.02),
  min_sets = 2,
  set_den = 2/1000,
  resample_cells = FALSE
)
}
\arguments{
\item{sim}{Simulation object from \code{\link{sim_distribution}}}

\item{subset_cells}{Logical expression indicating the elements (\code{x, y, depth, cell,
division, strat, year}) of the survey grid to keep (e.g., \code{cell
< 100})}

\item{n_sims}{Number of simulations to produce}

\item{trawl_dim}{Trawl width and distance (same units as grid)}

\item{min_sets}{Minimum number of sets per strat}

\item{set_den}{Set density (number of sets per grid unit squared)}

\item{resample_cells}{Allow resampling of sampling units (grid cells)?
(Note: allowing resampling may create bias because
depletion is imposed at the cell level)}
}
\value{
Returns a data.table including details of each set location.
}
\description{
Simulate survey sets
}
\examples{

\donttest{
sim <- sim_abundance(ages = 1:5, years = 1:5) \%>\%
          sim_distribution(grid = make_grid(res = c(20, 20)))

## Multiple calls can be useful for defining a custom series of sets
standard_sets <- sim_sets(sim, year <= 2, set_den = 2 / 1000)
reduced_sets <- sim_sets(sim, year > 2 & !cell \%in\% 1:100, set_den = 1 / 1000)
sets <- rbind(standard_sets, reduced_sets)
sets$set <- seq(nrow(sets)) # Important - make sure set has a unique ID.

survey <- sim_survey(sim, custom_sets = sets)

plot_survey(survey, which_year = 3, which_sim = 1)
}

}
