% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{simParallelEndpoints}
\alias{simParallelEndpoints}
\title{Generate Simulated Endpoint Data for Parallel Group Design}
\usage{
simParallelEndpoints(
  n,
  mu.arithmetic,
  mu.geometric = NULL,
  Sigma,
  CV = NULL,
  seed,
  dist = "normal"
)
}
\arguments{
\item{n}{Integer. The sample size for the generated data.}

\item{mu.arithmetic}{Numeric vector. The arithmetic mean of the endpoints on the original scale.}

\item{mu.geometric}{Numeric vector. The geometric mean of the endpoints on the original scale. Only used if \code{dist = "lognormal"}.}

\item{Sigma}{Matrix. Variance-covariance matrix of the raw data on the original scale. If \code{dist = "lognormal"}, this matrix is transformed to the log scale.}

\item{CV}{Numeric vector. Coefficient of variation (CV) of the raw data. Only used when \code{dist = "lognormal"}, where it is transformed to the log scale.}

\item{seed}{Integer. Seed for random number generation, ensuring reproducibility.}

\item{dist}{Character. Assumed distribution of the endpoints: either \code{"normal"} or \code{"lognormal"}.}
}
\value{
A matrix of simulated endpoint values for a parallel design, with dimensions \code{n} by the number of variables in \code{mu.arithmetic} or \code{mu.geometric}.
}
\description{
Generate simulated endpoint data for a parallel design, with options for normal and lognormal distributions.
}
\author{
Thomas Debray \email{tdebray@fromdatatowisdom.com}
}
