\name{skewhypFitStart}
\alias{skewhypFitStart}
\alias{skewhypFitStartLA}
\alias{skewhypFitStartMM}

\title{
Find Starting Values for Fitting a Skew Hyperbolic Student
t-Distribution
}
\description{
  Finds starting values for input to a maximum likelihood routine for
  fitting a skew hyperbolic \emph{t}-distribution to data.
}
\usage{
skewhypFitStart(x, breaks = NULL, startValues = "LA", paramStart = NULL,
...)
skewhypFitStartLA(x, breaks = NULL)
skewhypFitStartMM(x, nuTol = 1e-6, nuStart = 5, ...)
}
\arguments{
  \item{x}{Data vector.}
  \item{breaks}{Breaks for histogram. If missing defaults to those
    generated by \code{hist(x, right = FALSE, plot =FALSE)}. If
    \code{startValues = "LA"} then 30 breaks are used by default.}
  \item{startValues}{Code giving the method of determining starting
    values for finding the maximum likelihood estimates of the
    parameters.} 
  \item{paramStart}{If \code{startValues = "US"} the user must specify a
    vector of starting parameter values in the form
    \code{c(mu,delta,beta,nu)}.}
  \item{nuTol}{Tolerance for numerical determination of \code{nu} in
    \code{\link{skewhypFitStartMM}}}
  \item{nuStart}{Initial value for numerical determinationof \code{nu}
    in \code{\link{skewhypFitStartMM}}}
  \item{...}{Passes additional arguments to \code{\link{skewhypFitStartMM}}
  }
}
\details{
  \code{startValues} can be either \code{"US"}(User-supplied),
  \code{"LA"}(Linear approximation), or \code{"MM"}(Method of moments).

  If \code{startValues = "US"} then a value for \code{paramStart} must be
  supplied. The parameters are checked for validity by the function
  \code{skewhypCheckPars}.

  If \code{startValues = "LA"} a linear approximation is made to the
  log-density in each of the tails, from which the estimates for
  \eqn{\nu}{nu} and \eqn{\beta}{beta} are found. The remaining two
  parameters, \eqn{\delta}{delta} and \eqn{\mu}{mu} are found by solving
  the moment equations for mean and variance.  Since the variance does
  not exist for values of \eqn{\nu \le 4}{nu <= 4}, the estimate of
  \eqn{\nu}{nu} will be at least 4.1.  Note that if the distribution is
  too skewed, there are not enough points in the lighter tail to fit the
  required linear model, and the method will stop and return a
  warning. User supplied values will have to be used in this case.

  If \code{startValues = "MM"}, start values are found using the method
  of moments as outlined in Aas and Haff (2006).
}
\value{
  \code{skewhypFitStart} returns a list with components:
  \item{paramStart}{A vector of the form \code{c(mu,delta,beta,nu)}
    giving the generated starting values of the parameters.}
  \item{breaks}{The cell boundaries found by a call to \code{\link{hist}}.}
  \item{midpoints}{The cell midpoints found by a call to \code{\link{hist}}.}
  \item{empDens}{The estimated density at the midpoints found by a call
    to \code{\link{hist}} if \code{startValues = "US"} or
    \code{startValues = "MM"}, or to \code{\link{density}} if
    \code{startValues  = "LA"}.}
  \item{svName}{Name of the method used to find the starting values.}
}
\references{
  Aas, K. and Haff, I. H. (2006).
  The Generalised Hyperbolic Skew Student's \emph{t}-distribution,
  \emph{Journal of Financial Econometrics}, \bold{4}, 275--309.
}
\author{
  David Scott \email{d.scott@auckland.ac.nz}, Fiona Grimson
}

\seealso{
  \code{\link{hist}}, \code{\link{density}}, \code{\link{dskewhyp}},
  \code{\link{skewhypFit}}, \code{\link{skewhypCheckPars}}
}
\examples{
## find starting values to feed to skewhypFit
data(lrnokeur)
skewhypFitStart(lrnokeur, startValues="LA")$paramStart
## user supplied values
skewhypFitStart(lrnokeur, startValues="US",
                paramStart=c(0,0.01,0,5))$paramStart
}
\keyword{distribution}

