% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlsRound.R
\encoding{UTF8}
\name{RoundViaDummy}
\alias{RoundViaDummy}
\title{Small Count Rounding of Tabular Data}
\usage{
RoundViaDummy(data, freqVar, formula, roundBase = 3, singleRandom = FALSE,
  crossTable = TRUE, total = "Total", maxIterRows = 1000,
  maxIter = 1e+07)
}
\arguments{
\item{data}{Input data, data.frame or matrix}

\item{freqVar}{Variable holding counts (name or number)}

\item{formula}{Model formula defining publishable cells}

\item{roundBase}{roundBase}

\item{singleRandom}{Single random draw when TRUE (instead of algorithm)}

\item{crossTable}{When TRUE, cross table in output and caculations via FormulaSums()}

\item{total}{String used to name totals}

\item{maxIterRows}{See details}

\item{maxIter}{Maximum number of iterations}
}
\value{
A list where the two first elements are two column matrices.
The first matrix consists of inner cells and the second of cells to be published.
In each matrix the first and the second column contains, respectively, original and rounded values.
By default the cross table is the third element of the output list.
}
\description{
Small count rounding via a dummy matrix and by an algorithm inspired by PLS
}
\details{
Small count rounding of necessary inner cells are performed so that all small frequencies of cross-classifications to be published 
(publishable cells) are rounded. This is equivalent to changing micro data since frequencies of unique combinations are changed. 
Thus, additivity and consistency are guaranteed.
}
\note{
Iterations are needed since after initial rounding of identified cells, new cells are identified.
If cases of a high number of identified cells the algorithm can be too memory consuming (unless singleRandom=TRUE).
To avoid problems, not more than maxIterRows cells are rounded in each iteration.
The iteration limit (maxIter) is by default set to be high since a low number of maxIterRows may need a high number of iterations.
}
\examples{
RoundViaDummy(SmallCountData('z2'), 
              'ant', ~region + hovedint + fylke*hovedint + kostragr*hovedint, 10)
mf <- ~region*mnd + hovedint*mnd + fylke*hovedint*mnd + kostragr*hovedint*mnd
a <- RoundViaDummy(SmallCountData('z3'), 'ant', mf, 5)
b <- RoundViaDummy(SmallCountData('sosialFiktiv'), 'ant', mf, 4)
print(cor(b[[2]]),digits=12) # Correlation between original and rounded
}
\seealso{
See Round2() for rounding by other algorithm
}
