% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_ExpCompViz.R
\name{ExpTwoPlots}
\alias{ExpTwoPlots}
\title{Function to create two independent plots side by side for the same variable}
\usage{
ExpTwoPlots(
  data,
  plot_type = "numeric",
  iv_variables = NULL,
  target = NULL,
  lp_geom_type = "boxplot",
  lp_arg_list = list(),
  rp_geom_type = "boxplot",
  rp_arg_list = list(),
  fname = NULL,
  page = NULL,
  theme = "Default"
)
}
\arguments{
\item{data}{dataframe}

\item{plot_type}{the plot type ("numeric", "categorical").}

\item{iv_variables}{list of independent variables. this input will be based off plot_type. List of numeric variables / List of categorical variables}

\item{target}{binary or multi-class dependent variable}

\item{lp_geom_type}{left side geom plot. this option is for univariate data. Options for numeric are "boxplot", "histogram", "density", "violin", "qqplot" and for categorical "bar", "pie", "donut"}

\item{lp_arg_list}{arguments to be passed to lp_geom_type. Default is list()}

\item{rp_geom_type}{right side geom plot. Options for numeric are "boxplot", "histogram", "density", "violin" "qqplot"  and for categorical "bar", "pie", "donut"}

\item{rp_arg_list}{arguments to be passed to rp_geom_type. Default is list()}

\item{fname}{output file name. Output will be generated in PDF format}

\item{page}{output pattern. if Page=c(3,2), It will generate 6 plots with 3 rows and 2 columns}

\item{theme}{adding extra themes, geoms, and scales for 'ggplot2' (eg: themes options from ggthemes package)}
}
\value{
This function returns same variable in two different views of ggplot in one graph. And there is a option to save the graph into PDF or JPEG format.
}
\description{
To plot graph from same variable when Target=NULL vs. when Target = categorical
variable (binary or multi-class variable)
}
\examples{
## Bar graph for specified variable
# Let's consider mtcars data set, it has several numerical and binary columns
target = "gear"
categorical_features <- c("vs", "am", "carb")
numeircal_features <- c("mpg", "cyl", "disp", "hp", "drat", "wt", "qsec")

# plot numerical data two independent plots:
# Left side histogram chart wihtout target and Right side boxplot chart with target
num_1 <- ExpTwoPlots(mtcars, plot_type = "numeric",
iv_variables = numeircal_features, target = "gear",
lp_arg_list = list(alpha=0.5, color = "red", fill= "white",
binwidth=1),lp_geom_type = 'histogram',
rp_arg_list = list(fill = c("red", "green", "blue")),
rp_geom_type = 'boxplot', page = c(2,1),theme = "Default")

# plot categorical data with two independent plots:
# Left side Donut chart wihtout target and Right side Stacked bar chart with target
cat_1 <- ExpTwoPlots(mtcars,plot_type = "categorical",
iv_variables = categorical_features,
target = "gear",lp_arg_list = list(),lp_geom_type = 'donut',
rp_arg_list = list(stat = 'identity', ),
rp_geom_type = 'bar',page = c(2,1),theme = "Default")

}
