% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plant_diversity.R
\name{plant_diversity}
\alias{plant_diversity}
\title{Calculate plant diversity indicators}
\usage{
plant_diversity(var_MGMT_data, start_year, end_year)
}
\arguments{
\item{var_MGMT_data}{a 'management_df' with a management history}

\item{start_year}{start year of the cropping sequence of interest}

\item{end_year}{end year of the cropping sequence of interest}
}
\value{
a tibble with three indicators for plant diversity
}
\description{
Derives three indicators for plant diversity of a crop rotation based
on management information (mainly sowing events).
}
\details{
For the function to work properly the species (or variety) must be mentioned
in the "product" column, and all sown species of mixtures must be
represented in a single row of the \code{management_df} each.

The function calculates the plant diversity index (\eqn{PDI}), the total
number of different species, and the Shannon index  for all sown species.

The \eqn{PDI} is calculated in the following way inspired by
\insertCite{Tiemann_2015;textual}{SoilManageR}:
\deqn{PDI = \overline{S_{year}} * S_{rotation}}
where \eqn{\overline{S_{year}}} is the average number of sown species per
year and \eqn{S_{rotation}} is the total number of different species
sown in the full crop rotation or cropping sequence.

The Shannon Index is calculated with the \code{\link[=shannon_index]{shannon_index()}} function.
}
\examples{
plant_diversity(EXAMPLE_data,2013,2020)

}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[=calculate_indicators]{calculate_indicators()}} to calculate all management indicators
for a \code{management_df}
\item \code{\link[=shannon_index]{shannon_index()}} for more detail on the Shannon index
}
}
