% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_yield.R
\name{relative_yield}
\alias{relative_yield}
\title{Calculate relative yield}
\usage{
relative_yield(var_crop, var_yield)
}
\arguments{
\item{var_crop}{string with name of crop type,
must match with the Crops in the C_input_crops_LUT}

\item{var_yield}{observed dry matter yield (tDM/ha)}
}
\value{
the numeric value for the relative yield
}
\description{
This function calculates the relative yield of an observed
dry matter yield compared to the reference dry matter yield
in the Swiss fertilizing guidelines \insertCite{GRUD2017_ch8}{SoilManageR}.
}
\examples{
relative_yield("wheat, winter", 4.8)
}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
\item \code{\link[=productivity_indicator]{productivity_indicator()}} to calculate relative yields for a \code{management_df}
\item \code{\link[=C_input_crops_LUT]{C_input_crops_LUT()}} for reference yield used in the \code{\link[=relative_yield]{relative_yield()}} function
}
}
