% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higherTaxaCodes.R
\name{relative_taxon_code_position}
\alias{relative_taxon_code_position}
\title{Determine relative position of taxon within Keys to Soil Taxonomy (Order to Subgroup)}
\usage{
relative_taxon_code_position(code)
}
\arguments{
\item{code}{A character vector of taxon codes to determine the relative position of.}
}
\value{
A numeric vector with the relative position of each code with respect to their individual Keys.
}
\description{
The relative position of a taxon is \verb{[number of preceding Key steps] + 1}, or \code{NA} if it does not exist in the lookup table.
}
\examples{

# "ABCD" -> "Gypsic Anhyturbels", relative position 7
# "WXYZa" does not exist, theoretical position is 97
# "BAD" -> "Udifolists", relative position is 5

relative_taxon_code_position(c("ABCD", "WXYZa", "BAD"))

# [1]  7 NA  5

}
