% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{ST_criteria_13th}
\alias{ST_criteria_13th}
\title{Keys to Soil Taxonomy Criteria (13th Edition)}
\format{
An object of class \code{list} of length 3153.
}
\usage{
data(ST_criteria_13th)
}
\description{
A lookup table relating taxon codes to specific criteria from the Keys to
Soil Taxonomy (13th Edition)
}
\details{
A \code{list} containing one element per taxon code at order to subgroup level.
Each element contains a \code{data.frame} with 1 row per criterion, and 8 columns:

Each \code{data.frame} contains the following columns:
\itemize{
\item \code{content} (text content of criterion)
\item \code{chapter} (chapter number)
\item \code{page} (page number)
\item \code{key} (key name or level)
\item \code{taxon} (taxon name)
\item \code{code} (taxon code)
\item \code{clause} (sequence number of criterion within taxon)
\item \code{logic} (logical meaning of criterion)
\itemize{
\item One of:
\itemize{
\item \code{FIRST} (first)
\item \code{OR} (either this criterion OR the next criterion at same level)
\item \code{END} (end of hierarchical key)
\item \code{NEW} (go to new page/taxon specified)
\item \code{AND} (this criterion AND the next criterion at same level)
\item \code{HAVE} (criteria that must be met)
\item \code{LAST} (end of subgroup key)
}
}
}
}
\references{
Soil Survey Staff. 2022. Keys to Soil Taxonomy, 13th ed. USDA-Natural
Resources Conservation Service.
\url{https://www.nrcs.usda.gov/resources/guides-and-instructions/keys-to-soil-taxonomy}
}
\keyword{datasets}
