% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-transform.R
\name{transform}
\alias{transform}
\alias{transform.soma_adat}
\title{Scale Transform \code{soma_adat} Columns/Rows}
\usage{
\method{transform}{soma_adat}(`_data`, v, dim = 2L, ...)
}
\arguments{
\item{_data}{A \code{soma_adat} object.}

\item{v}{A numeric vector of the appropriate length corresponding to \code{dim}.}

\item{dim}{Integer. The dimension to apply elements of \code{v} to.
\code{1} = rows; \code{2} = columns (default).}

\item{...}{Currently not used but required by the S3 generic.}
}
\value{
A modified value of \verb{_data} with either the rows or columns
linearly transformed by \code{v}.
}
\description{
Scale the \emph{i-th} row or column of a \code{soma_adat} object by the \emph{i-th}
element of a vector. Designed to facilitate linear transformations
of \emph{only} the analyte/RFU entries by scaling the data matrix.
If scaling the analytes/RFU (columns), \code{v} \emph{must} have
\code{getAnalytes(adat, n = TRUE)} elements.
If scaling the samples (rows), \code{v} \emph{must}
have \verb{nrow(_data)} elements.
}
\details{
Performs the following operations (quickly):

Columns:
\deqn{
  M_{nxp} = A_{nxp} * diag(v)_{pxp}
}

Rows:
\deqn{
  M_{nxp} = diag(v)_{nxn} * A_{nxp}
}
}
\note{
This method in intentionally naive, and assumes the user has
ordered \code{v} to match the columns/rows of \verb{_data} appropriately.
This must be done upstream.
}
\examples{
# simplified example of underlying operations
M <- matrix(1:12, ncol = 4)
M

v <- 1:4
M \%*\% diag(v)    # transform columns

v <- 1:3
diag(v) \%*\% M    # transform rows

# dummy ADAT example:
v    <- c(2, 0.5)     # double seq1; half seq2
adat <- data.frame(sample      = paste0("sample_", 1:3),
                   seq.1234.56 = c(1, 2, 3),
                   seq.9999.88 = c(4, 5, 6) * 10)
adat

# `soma_adat` to invoke S3 method dispatch
class(adat) <- c("soma_adat", "data.frame")
trans <- transform(adat, v)
data.frame(trans)
}
\seealso{
\code{\link[=apply]{apply()}}, \code{\link[=sweep]{sweep()}}
}
