% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ca.R
\name{summary.ca}
\alias{summary.ca}
\title{Return the output of \code{\link{ca}} function.}
\usage{
\method{summary}{ca}(object, ...)
}
\arguments{
\item{object}{Output of \code{\link{ca}} command with
\code{interest = "moments"}.}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
Return the output of \code{\link{ca}} function.
}
\examples{
data("mortgage")
### Regression Specification
fm <- deny ~ black + p_irat + hse_inc + ccred + mcred + pubrec +
ltv_med + ltv_high + denpmi + selfemp + single + hischl
### Specify characteristics of interest
t <- c("deny", "p_irat", "black", "hse_inc", "ccred", "mcred", "pubrec",
"denpmi", "selfemp", "single", "hischl", "ltv_med", "ltv_high")
### Issue ca command
CA <- ca(fm = fm, data = mortgage, var = "black", method = "logit",
cl = "both", t = t, b = 50, bc = TRUE)
### Report summary table
summary(CA)
}
