% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.R
\name{Copy,simList-method}
\alias{Copy,simList-method}
\title{Copy for \code{simList} class objects}
\usage{
\S4method{Copy}{simList}(object, objects, queues, modules, ...)
}
\arguments{
\item{object}{An R object (likely containing environments) or an environment.}

\item{objects}{Whether the objects contained within the \code{simList} environment
should be copied. Default \code{TRUE}, which may be slow.}

\item{queues}{Logical. Should the events queues (\code{events}, \code{current}, \code{completed})
be deep copied via \code{data.table::copy()}}

\item{modules}{Logical. Should list of modules be copied.}

\item{...}{Only used for custom Methods}
}
\value{
a copy of \code{object}
}
\description{
Because a \code{simList} works with an environment to hold all objects,
all objects within that slot are pass-by-reference.
That means it is not possible to simply copy an object with an assignment operator:
the two objects will share the same objects.
As one \code{simList} object changes so will the other.
When this is not the desired behaviour, use this function.
}
\details{
\code{simList} objects can contain a lot of information, much of which could be
in pass-by-reference objects (e.g., \code{data.table} class), and objects that are
file-backed, such as some \verb{Raster*}-class objects. For all the objects that
are file-backed, it is likely \emph{very} important to give unique file-backed
directories. This should be passed here, which gets passed on to the many methods
of \code{Copy} in \code{reproducible}.
}
\note{
uses capital C, to limit confusion with e.g., \code{data.table::copy()}.
}
\seealso{
\code{\link[reproducible:Copy]{reproducible::Copy()}}

\code{\link[reproducible:Copy]{reproducible::Copy()}}
}
\author{
Eliot McIntire
}
