% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\name{envir}
\alias{envir}
\alias{simList-accessors-envir}
\alias{envir,simList-method}
\alias{envir<-}
\alias{envir<-,simList-method}
\title{Simulation environment}
\usage{
envir(sim)

\S4method{envir}{simList}(sim)

envir(sim) <- value

\S4method{envir}{simList}(sim) <- value
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or in which to replace element(s).}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{.xData} slot, which is the default virtual
slot for an S4 class object that inherits from an S3 object (specifically,
the \code{simList} inherits from \code{environment}) in a \code{simList} object.
These are included for advanced users.
}
\details{
Currently, only get and set methods are defined. Subset methods are not.
}
\seealso{
\link{SpaDES.core-package}, specifically the section 1.2.8 on \code{simList} environment.

Other functions to access elements of a 'simList' object: 
\code{\link{.addDepends}()},
\code{\link{checkpointFile}()},
\code{\link{events}()},
\code{\link{globals}()},
\code{\link{inputs}()},
\code{\link{modules}()},
\code{\link{objs}()},
\code{\link{packages}()},
\code{\link{params}()},
\code{\link{paths}()},
\code{\link{progressInterval}()},
\code{\link{times}()}
}
\author{
Alex Chubaty
}
\concept{functions to access elements of a 'simList' object}
