% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-diagrams.R
\docType{methods}
\name{moduleDiagram}
\alias{moduleDiagram}
\alias{moduleDiagram,simList,character,logical-method}
\alias{moduleDiagram,simList,missing,ANY-method}
\title{Simulation module dependency diagram}
\usage{
moduleDiagram(sim, type, showParents, ...)

\S4method{moduleDiagram}{simList,character,logical}(sim, type, showParents, ...)

\S4method{moduleDiagram}{simList,missing,ANY}(sim, type, showParents, ...)
}
\arguments{
\item{sim}{A \code{simList} object (typically corresponding to a
completed simulation).}

\item{type}{Character string, either \code{"rgl"} for \code{igraph::rglplot}
or \code{"tk"} for \code{igraph::tkplot}. Default missing, which uses regular
\code{plot}.}

\item{showParents}{Logical. If TRUE, then any children that are grouped into parent
modules will be grouped together by colored blobs. Internally,
this is calling \code{\link{moduleGraph}}. Default \code{FALSE}.}

\item{...}{Additional arguments passed to plotting function specfied by \code{type}.}
}
\value{
Plots module dependency diagram.
}
\description{
Create a network diagram illustrating the simplified module dependencies of a
simulation. Offers a less detailed view of specific objects than does
plotting the \code{depsEdgeList} directly with \code{\link{objectDiagram}}.
}
\author{
Alex Chubaty
}
\seealso{
\code{\link{igraph}}, \code{\link{moduleGraph}} for a version that accounts for
parent and children module structure.
}

