% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{monotonically_increasing_id}
\alias{monotonically_increasing_id}
\alias{monotonically_increasing_id}
\alias{monotonically_increasing_id,missing-method}
\title{monotonically_increasing_id}
\usage{
monotonically_increasing_id(x = "missing")

\S4method{monotonically_increasing_id}{missing}()
}
\arguments{
\item{x}{empty. Should be used with no argument.}
}
\description{
Return a column that generates monotonically increasing 64-bit integers.
}
\details{
The generated ID is guaranteed to be monotonically increasing and unique, but not consecutive.
The current implementation puts the partition ID in the upper 31 bits, and the record number
within each partition in the lower 33 bits. The assumption is that the SparkDataFrame has
less than 1 billion partitions, and each partition has less than 8 billion records.

As an example, consider a SparkDataFrame with two partitions, each with 3 records.
This expression would return the following IDs:
0, 1, 2, 8589934592 (1L << 33), 8589934593, 8589934594.

This is equivalent to the MONOTONICALLY_INCREASING_ID function in SQL.
}
\examples{
\dontrun{select(df, monotonically_increasing_id())}
}
\seealso{
Other misc_funcs: \code{\link{crc32}}, \code{\link{hash}},
  \code{\link{md5}}, \code{\link{sha1}}, \code{\link{sha2}}
}
