% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sparse_chol_crs}
\alias{sparse_chol_crs}
\title{Sparse Cholesky decomposition with sparse representation}
\usage{
sparse_chol_crs(n, Ap, Ai, Ax)
}
\arguments{
\item{n}{Integer specifying the dimension of the matrix}

\item{Ap}{numeric (integer valued) vector of pointers, one for each column (or row), to the initial (zero-based) index of elements in the column (or row).}

\item{Ai}{Integer vector specifying the row positions of the non-zero values of the matrix}

\item{Ax}{values of the non-zero matrix entries}
}
\value{
A list with elements n, Ai, Ap, Ax (corresponding to above arguments) for matrix L, and element D, which 
contains the diagonal values of matrix D.
}
\description{
Sparse Cholesky decomposition with sparse representation
}
\details{
Generates the LDL decomposition of a symmetric, sparse matrix using the method 
described by Timothy Davis (see references). Required input is a matrix
in sparse format from the matrix package, see \link[Matrix]{sparseMatrix}, or the
package function \link[SparseChol]{dense_to_sparse}. To instead use a matrix directly, see \link[SparseChol]{sparse_chol}.
}
\examples{
n <- 10
Ap <- c(0, 1, 2, 3, 4, 6, 7, 9, 11, 15, 19)
Ai <- c(1, 2, 3, 4, 2,5, 6, 5,7, 5,8, 1,5,8,9, 2,5,7,10)
Ax <- c(1.7, 1., 1.5, 1.1, .02,2.6, 1.2, .16,1.3, .09,1.6,
          .13,.52,.11,1.4, .01,.53,.56,3.1)
out <-sparse_chol_crs(n,Ap,Ai,Ax)
sparse_L(out)
sparse_D(out)
}
