% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batty_karlstrom_entropy.R
\name{areapart}
\alias{areapart}
\title{Area partition.}
\usage{
areapart(win, G, data.coords)
}
\arguments{
\item{win}{The observation area, an object of class \code{owin}, see package \code{spatstat}.}

\item{G}{An integer if sub-areas are randomly generated, determining the number \eqn{G} of sub-areas.
Alternatively, a \eqn{G}x\eqn{2} matrix with the sub-areas centroids' coordinates.}

\item{data.coords}{A two column matrix. If the dataset is a point pattern,
the point coordinates. If the dataset is a raster/pixel matrix,
the centroids' coordinates, provided by user or returned by \code{\link[=coords_pix]{coords_pix()}}.}
}
\value{
A list with elements:
\itemize{
\item \code{G.coords} a point pattern containing the \eqn{G} areas' centroids
\item \code{data.assign} a three column matrix, where each pair of data coordinates is
matched to one of the \eqn{G} areas (numbered 1 to \eqn{G}).
}
}
\description{
This function partitions the observation area in a number of sub-areas,
and assigns the data points/pixels to the areas.
}
\details{
An event of interest (in the form of a point or binary areal dataset) occurs
over an observation area divided into sub-areas. If the partition is random,
this function generates the sub-areas by randomly drawing the areas' centroids
over the observation window. Then, data points/pixels are assigned to the area with
the closest centroid.
}
\examples{
#LATTICE DATA
#random generation of areas
ccc=coords_pix(area=square(10), nrow=10, ncol=10)
partition=areapart(square(10), G=5, data.coords=ccc)

#providing a pre-fixed area partition
win=square(10)
G=5
GG=cbind(runif(G, win$xrange[1], win$xrange[2]),
         runif(G, win$yrange[1], win$yrange[2]))
ccc=coords_pix(area=win, pixel.xsize = 2, pixel.ysize = 2)
partition=areapart(win, G=GG, data.coords=ccc)

#POINT DATA
#random generation of areas
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
ccc=coords(data.pp)
partition=areapart(square(10), G=4, data.coords=ccc)

#providing a pre-fixed area partition
win=square(10)
G=4
GG=cbind(runif(G, win$xrange[1], win$xrange[2]),
         runif(G, win$yrange[1], win$yrange[2]))
data.pp=runifpoint(100, win=win)
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
ccc=coords(data.pp)
partition=areapart(win, G=GG, data.coords=ccc)

#for plotting the area partiton
?plot_areapart

}
