% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneill_leibovici_entropy.R
\name{contagion}
\alias{contagion}
\title{Li and Reynolds' relative contagion index.}
\usage{
contagion(oneill = NULL, n.cat = NULL, data = NULL, adj.mat = NULL,
  missing.cat = NULL, ordered = TRUE)
}
\arguments{
\item{oneill}{O'Neill's entropy as the output of \code{\link[=leibovici]{leibovici()}}.
If this is provided, nothing else needs to be specified, except for \code{n.cat} if wished.}

\item{n.cat}{Optional, an integer denoting the number of categories of the study variable.}

\item{data}{A data matrix or vector, can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is the mark vector.}

\item{adj.mat}{The contiguity matrix, upper- or lower-triangular.
Provided by user or generated by \code{\link[=adj_mat]{adj_mat()}}.}

\item{missing.cat}{Optional, a vector with the names of all categories that are absent in \code{data}.}

\item{ordered}{Logical, \code{T} if the entropy is computed using ordered couples
(see \code{\link[=couple_count]{couple_count()}}), \code{F} if it is computed using pairs (see \code{\link[=pair_count]{pair_count()}}).}
}
\value{
Li and Reynolds' contagion index, as well as a summary table containing the couples (or pairs)
along with their absolute and relative frequencies.
}
\description{
This function computes Li and Reynold's contagion index, following Li and Reynolds (1993),
starting from data or from the output of \code{\link[=leibovici]{leibovici()}}. References can be found at \code{SpatEntropy}.
}
\details{
This index is based on the transformed variable \eqn{Z} identifying couples of realizations
of the variable of interest. A distance of interest is fixed: the contagion index is
originally thought for areas sharing a border, as O'Neill's entropy. This corresponds to
creating a contiguity matrix as done by \code{\link[=adj_mat]{adj_mat()}}. Then, all couples
of realizations of the variable of interest identified by the adjacency matrix are counted
and their relative frequencies are used to compute the index, which is \eqn{1-NO} where \eqn{NO}
is the normalized O'Neill's entropy, i.e. O'Neill's entropy divided by its maximum \eqn{\log(I)},
\eqn{I} being the number of categories of the variable under study.
Couples can be ordered or not (pairs), with ordered couples as the default option
since it is the authors' choice. This function also allows to compute contagion for neighbourhood structures
different from contiguity, by suitably defining the adjacency matrix.
}
\examples{

dist.mat=euclid_dist(cbind(rep(1:5, each=5), rep(1:5,5)))
adj.mat=adj_mat(dist.mat, dd1=dist.mat[1,2]) #for the contiguity matrix
data=sample(1:3, 25, replace=TRUE)
oneill=leibovici(data, adj.mat)

contag=contagion(oneill)

contag=contagion(data=data, adj.mat=adj.mat)

}
