% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrierDecomp.R
\name{BrierDecomp}
\alias{BrierDecomp}
\alias{BrierScoreDecomposition}
\title{Brier Score decomposition}
\usage{
BrierDecomp(p, y, bins = 10, bias.corrected = FALSE)
}
\arguments{
\item{p}{vector of forecast probabilities}

\item{y}{binary observations, y[t]=1 if an event happens at time t, and y[t]=0 otherwise}

\item{bins}{binning to estimate the calibration function (see Details), default: 10}

\item{bias.corrected}{logical, default=FALSE, whether the standard (biased) decomposition of Murphy (1973) should be used, or the bias-corrected decomposition of Ferro (2012)}
}
\value{
Estimators of the three components and their estimated standard deviations are returned as a 2*3 matrix.
}
\description{
Return decomposition of the Brier Score into Reliability, Resolution and Uncertainty, and estimated standard deviations
}
\details{
To estimate the calibration curve, the unit line is categorised into discrete bins, provided by the `bins` argument. If `bins` is a single number, it specifies the number of equidistant bins. If `bins` is a vector of values between zero and one, these values are used as the bin-breaks.
}
\examples{
data(eurotempforecast)
BrierDecomp(rowMeans(ens.bin), obs.bin, bins=3, bias.corrected=TRUE)
}
\references{
Murphy (1973): A New Vector Partition of the Probability Score. J. Appl. Met. http://dx.doi.org/10.1175/1520-0450(1973)012<0595:ANVPOT>2.0.CO;2

Ferro and Fricker (2012): A bias-corrected decomposition of the Brier score. QJRMS. http://dx.doi.org/10.1002/qj.1924

Siegert (2013): Variance estimation for Brier Score decomposition. QJRMS. http://dx.doi.org/10.1002/qj.2228
}
\seealso{
ReliabilityDiagram
}
