% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{translateSqlFile}
\alias{translateSqlFile}
\title{Translate a SQL file}
\usage{
translateSqlFile(sourceFile, targetFile, sourceDialect = "sql server",
  targetDialect = "oracle", oracleTempSchema = NULL)
}
\arguments{
\item{sourceFile}{The source SQL file}

\item{targetFile}{The target SQL file}

\item{sourceDialect}{The source dialect. Currently, only 'sql server' for Microsoft SQL Server
is supported}

\item{targetDialect}{The target dialect. Currently 'oracle', 'postgresql', and 'redshift' are
supported}

\item{oracleTempSchema}{A schema that can be used to create temp tables in when using Oracle.}
}
\description{
This function takes SQL and translates it to a different dialect.
}
\details{
This function takes SQL and translates it to a different dialect.
}
\examples{
\dontrun{
translateSqlFile("myRenderedStatement.sql",
                 "myTranslatedStatement.sql",
                 targetDialect = "postgresql")
}
}

