% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residualsfitStMoMo.R
\name{plot.resStMoMo}
\alias{plot.resStMoMo}
\title{Plot the residuals of a Stochastic Mortality Model}
\usage{
\method{plot}{resStMoMo}(x, type = c("scatter", "colourmap", 
                                            "signplot"), 
                                reslim = NULL, plotAge = TRUE, 
                                plotYear = TRUE, plotCohort  = TRUE, 
                                pch = 20, col = NULL, ...)
}
\arguments{
\item{x}{an object of class \code{resStMoMo} with the residuals of a 
Stochastic Mortality Model.}

\item{type}{the type of the plot. The alternatives are 
\code{"scatter"}(default), \code{"colourmap"}, and \code{"signplot"}.}

\item{reslim}{optional numeric vector of length 2, giving the range of the 
residuals.}

\item{plotAge}{logical value indicating if the age scatter plot should be 
produced. This is only used when \code{type = "scatter"}.}

\item{plotYear}{logical value indicating if the calendar year scatter plot 
should be produced. This is only used when \code{type = "scatter"}.}

\item{plotCohort}{logical value indicating if the cohort scatter plot 
should be produced. This is only used when \code{type = "scatter"}.}

\item{pch}{optional symbol to use for the points in a scatterplot. 
This is only used when \code{type = "scatter"}. See 
\code{\link[graphics]{plot}}.}

\item{col}{optional colours to use in plotting. If 
\code{type = "scatter"} this is a single colour to use in the points
in the scatter plots, while if \code{type = "colourmap"} this should
be a list of colours (see help in \code{\link[fields]{image.plot}} 
for details). This argument is ignored if \code{type = "signplot"}.}

\item{...}{other plotting parameters to be passed to the plotting 
functions. This can be used to control the appearance of the plots.}
}
\description{
Plots the deviance residuals of a Stochastic Mortality Model which are 
of class \code{"resStMoMo"}. Three types of plots
are available: scatter plot of residuals by age, period and cohort,
colour map (heatmap) of the residuals, and a black and white signplot 
of the residuals.
}
\details{
When \code{type = "scatter"} scatter plots of the residuals against age, 
calendar year and cohort (year of birth) are produced. 

When \code{type = "colourmap"} a two dimensional colour map of the 
residuals is plotted. This is produced using function 
\code{\link[fields]{image.plot}}. See \code{\link[fields]{image.plot}} 
for further parameters that can be passed to this type of plots.

When \code{type = "signplot"} a two dimensional black and white map of the
 residuals is plotted with dark grey representing negative residuals and 
 light grey representing positive residuals. This is produced using 
 function \code{\link[graphics]{image.default}}. 
  
 @seealso \code{\link{residuals.fitStMoMo}}
}
\examples{
CBDfit <- fit(cbd(), Dxt = EWMaleData$Dxt, Ext = EWMaleData$Ext, 
              ages = EWMaleData$ages, years = EWMaleData$years,
              ages.fit = 55:89)
CBDres <- residuals(CBDfit)
plot(CBDres)
plot(CBDres, type = "signplot")
plot(CBDres, type = "colourmap")
  
}

