% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportUtils.R
\name{StMoMoData}
\alias{StMoMoData}
\title{Create StMoMoData object from demogdata object}
\usage{
StMoMoData(data, series = names(data$rate)[1], type = c("central",
  "initial"))
}
\arguments{
\item{data}{demogdata object of type "mortality". It is either the
output from functions \code{\link[demography]{read.demogdata}} or 
\code{\link[demography]{hmd.mx}} of package \code{demography}.}

\item{series}{name of series within \code{data} to use.}

\item{type}{the type of exposure that should be included in the 
output. The alternatives are \code{"central"} (default) and 
\code{"initial"}.  \code{"central"} exposures are suitable for fitting
models under a log-Poisson framework while \code{"initial"} exposures
are suitable under a logit-Binomial framework.}
}
\value{
A list with class \code{"StMoMoData"} with components:
  
  \item{Dxt}{ matrix of deaths data.}   
  
  \item{Ext}{ matrix of observed exposures.} 
  
  \item{ages}{ vector of ages corresponding to rows of \code{Dxt} and 
  \code{Ext}.} 
  
  \item{years}{ vector of years corresponding to rows of \code{Dxt} and 
  \code{Ext}.} 
  
  \item{type}{ the type of exposure in the data.}
  
  \item{series}{ name of the extracted series.}
  
  \item{label}{ label of the data.}
}
\description{
Create StMoMoData object suitable for fitting a Stochastic Mortality 
Model using function \code{\link{fit.StMoMo}}.
}
\examples{
\dontrun{
library(demography)
NZdata <- hmd.mx(country = "NZL_NP", username = username, password = password, 
label = "New Zealand")
NZStMoMo <- StMoMoData(NZdata, series = "male")
summary(NZStMoMo)
}

}
