% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_methods-PERFORMANCE.R
\docType{methods}
\name{VaR}
\alias{VaR}
\alias{VaR,Strategy-method}
\title{Value at Risk}
\usage{
VaR(object, alpha=0.05, V=1, type="normal.distribution"
       , method="full", of="portfolio"
       , from=NULL, until=NULL, which=NULL
       , scaling.periods=NULL, include.weights=TRUE
       , include.costs=TRUE, use.backtest=FALSE)

\S4method{VaR}{Strategy}(object, alpha = 0.05, V = 1,
  type = c("normal.distribution", "historical"), method = c("full",
  "linear"), of = c("portfolio", "assets"), from = NULL, until = NULL,
  which = NULL, scaling.periods = NULL, include.weights = TRUE,
  include.costs = TRUE, use.backtest = FALSE)
}
\arguments{
\item{object}{An object of class \code{Strategy}.}

\item{alpha}{The significance level \eqn{\alpha} that is used for propability of cumulative loss at level \eqn{1-\alpha}.}

\item{V}{Volume that is invested. The linear factor for the VaR calculation. Either a single value for portfolio or a vector for each asset.}

\item{type}{Type of VaR calculation. Use \code{normal.distribution} for the normal distribution, \code{historical} for the empirical distribution. Default value is \code{historical}.}

\item{method}{Method of loss calculation. Use \code{linear} for approximation with log returns or \code{full} for calculation with arithmetic returns. Default value is \code{full}.}

\item{of}{VaR to be calculated for assets separately or the portfolio.}

\item{from}{The date in character format \code{"yyyy-MM-dd"} or as date-object from which losses shall be considered. If \code{NULL}, no restriction is made.}

\item{until}{The date in character format \code{"yyyy-MM-dd"} or as date-object until which losses shall be considered. If \code{NULL}, no restriction is made.}

\item{which}{Names or number of assets that should be included in calculation.}

\item{scaling.periods}{Vector with annualization factors for calculation. Default is 252, 52, 12, 4, 1 for daily, weekly, monthly, quarterly and yearly data respectively.}

\item{include.weights}{Only relevant if \code{of="assets"}: If \code{FALSE}, weights are all set to \code{1}. This might be necessary if only single stock performance without weighting shall be considered.}

\item{include.costs}{If \code{FALSE}, the fixed and relative trading costs are NOT considered for performance calculation. Default value is \code{TRUE}. As default values for costs are \code{0}, this argument is obsolete if no costs are given.}

\item{use.backtest}{If \code{TRUE}, the performance of the backtesting output is considered for VaR calculation. If \code{FALSE}, the performance of the initial strategy execution are used.}
}
\description{
Value at Risk of the assets or portfolio of an object of class \code{Strategy}.
}
\examples{
## Not run:

# MA(200)-Strategy
params <- list(k=200)
myStrat.MA <- Strategy(assets=assets, strat="MA", strat.params=params)

# Get VaR of MA(200)-Strategy portfolio
VaR(myStrat.MA, from="2015-01-01", until="2015-12-31")

# Get backtest VaR of MA(200)-Strategy
# VaR(myStrat.MA, from="2015-01-01", until="2015-12-31", use.backtest=TRUE)

## End(Not run)
}

