% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ple_glmnet.R
\name{predict.ple_glmnet}
\alias{predict.ple_glmnet}
\title{Predict Patient-level Estimates: glmnet}
\usage{
\method{predict}{ple_glmnet}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Trained glmnet model(s).}

\item{newdata}{Data-set to make predictions at (Default=NULL, predictions correspond
to training data).}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-frame with predictions of (E(Y|X,A=1), E(Y|X,A=0), E(Y|X,A=1)-E(Y|X,A=0))
for continuous/binary outcomes. For survival, returns (HR(X,A=1), HR(X,A=0),
HR(X, A=1)-HR(X, A=0)).
}
\description{
For continuous/binary (family="gaussian" or "binomial"), output estimates of
(E(Y|X,A=1), E(Y|X,A=0), E(Y|X,A=1)-E(Y|X,A=0)). For survival, output estimates of
(HR(X,A=1), HR(X,A=0), HR(X, A=1)-HR(X, A=0)).
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

mod1 = ple_glmnet(Y, A, X, Xtest=X, family="gaussian")
summary(mod1$mu_train)
summary(predict(mod1)) # Training set predictions, newdata=NULL
summary(predict(mod1, newdata=X)) # Test set predictions

}
