% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landing.R
\name{landingRM}
\alias{landingRM}
\title{Landing by suppression of variables}
\usage{
landingRM(X, pikstar)
}
\arguments{
\item{X}{matrix of auxiliary variables on which the sample must be balanced. (The matrix should be divided by the original inclusion probabilities.)}

\item{pikstar}{vector of updated inclusion probabilities by the flight phase. See \code{\link{ffphase}}}
}
\value{
A vector with elements equal to 0 or 1. The value 1 indicates that the unit is selected while the value 0 is for rejected units.
}
\description{
This function performs the landing phase of the cube method using suppression of variables proposed by Chauvet and Tillé (2006).
}
\examples{

N <- 1000
n <- 10
p <- 4
pik <- rep(n/N,N)
X <- cbind(pik,matrix(rgamma(N*p,4,25),ncol= p))
pikstar <- ffphase(X,pik) 
s <- landingRM(X/pik,pikstar)
sum(s)
t(X/pik)\%*\%pik
t(X/pik)\%*\%pikstar
t(X/pik)\%*\%s
}
\references{
Chauvet, G. and Tillé, Y. (2006). A fast algorithm of balanced sampling. \emph{Computational Statistics}, 21/1:53-62
}
\seealso{
\code{\link{fbs}}, \code{\link{balstrat}}.
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
