% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strucDivDom.R
\name{strucDivDom}
\alias{strucDivDom}
\title{Returns the structural diversity value, the gray level co-occurrence matrix (GLCM) and the structural diversity 
matrix of the domain.}
\usage{
strucDivDom(x, dist = 1, angle = "all", rank = FALSE, fun, delta = 0)
}
\arguments{
\item{x}{raster layer. Input raster layer for which 
structural diversity should be calculated.}

\item{dist}{integer. The distance between two pixels that should be considered as a pair, 
defaults to \code{dist = 1} (direct neighbors).}

\item{angle}{string. The angle on which pixels should be considered as pairs. 
Takes 5 options: \code{"horizontal"}, \code{"vertical"}, \code{"diagonal45"}, \code{"diagonal135"}, \code{"all"}. 
The direction-invariant version is \code{"all"}, which considers all of the 4 angles. Defaults to \code{"all"}.}

\item{rank}{logical. Should pixel values be replaced with ranks in each GLCM? Defaults to \code{FALSE}.}

\item{fun}{function, the structural diversity metric. Takes one of the following: \code{entropyDom},
\code{entropyNormDom}, \code{contrastDom}, \code{dissimilarityDom}, or \code{homogeneityDom}. 
Structural diversity entropy is \code{entropyDom} with different \code{delta} parameters. 
Shannon entropy is employed when \code{delta = 0}. 
Shannon entropy has a scale-dependent maximum. Scale-dependent means dependent on the extent of he area within which
structural diversity is quantified, because this area defines he total number of pixel pairs.
The metric \code{entropyNormDom} is Shannon entropy normalized over scale-dependent maximum entropy. 
Additionally, the value gradient is considered with \code{delta = 1} and \code{delta = 2}. 
The values of structural diversity entropy with \code{delta = 1} or \code{delta = 2} are not restricted 
and depend on the values of the input raster.
The metrics \code{contrastDom} and \code{dissimilarityDom} consider the value gradient,
 their values are not restricted and depend on the values of the input raster.
The metric \code{homogeneityDom} quantifies the closeness of empirical probabilities to the diagonal and ranges between 0 and 1.}

\item{delta}{numeric, takes three options: \code{0}, \code{1}, or \code{2}. 
The parameter \code{delta} is the difference weight, 
it defines how the differences between pixel values within a pixel pair should be weighted.  
If \code{rank = TRUE}, delta defines how the differences between ranks should be weighted.  
Defaults to \code{0} (no weight). Set \code{delta = 1} for absolute weights, 
or \code{delta = 2} for square weights. 
The \code{delta} parameter can only be set when the metric \code{entropy} is used. 
the metric \code{dissimilarity} automatically employs \code{delta = 1}, and \code{contrast} employs \code{delta = 2}.}
}
\value{
The output is a list containing the structural diversity value of the domain, which can be accessed with $div. 
the list also contains the gray level co-occurrence matrix ($GLCM) and the structural diversity 
matrix ($divMat) of the domain.
}
\description{
The function \code{strucDivDom} returns the spatial, i.e. horizontal, structural diversity value for the domain (i.e. the input raster). 
'Spatial structural diversity' will hereafter be used synonymous to 'structural diversity'.
The function also returns the gray level co-occurrence matrix (GLCM) and the structural diversity matrix of 
the domain. Structural diversity is calculated on every element of the GLCM,
which generates the structural diversity matrix.
}
\details{
The memory requirement of the function is determined 
by \code{raster::canProcessInMemory()}. 
If the raster file cannot be processed in memory, its size needs to be 
reduced before \code{\link{strucDivDom}} can be used.
}
\examples{
\dontrun{
# Calculate entropy on simulated random patch data
a <- raster::raster(matrix(rnorm(100), 10, 10))
sdivDom <- strucDivDom(a, angle = "vertical", fun = entropyDom)
# Structural diversity value of the domain
div <- sdivDom$div
# Gray level co-occurrence matrix
glcm <- sdivDom$GLCM
# Diversity matrix
divmat <- sdivDom$divMat
}
}
