% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aim_batting.R
\name{cox.interaction}
\alias{cox.interaction}
\title{Interaction Cox AIM}
\usage{
cox.interaction(x, trt, y, delta, nsteps = 8, mincut = 0.1, backfit = F,
  maxnumcut = 1, dirp = 0)
}
\arguments{
\item{x}{the predictor matrix.}

\item{trt}{the treatment indicator vector.}

\item{y}{the vector of the time to event response variable.}

\item{delta}{status indicator: 1=failure 0=alive}

\item{nsteps}{the maximum number of binary rules to be included in the index.}

\item{mincut}{the minimum cutting proportion for the binary rule at either end. It typically is between 0 and 0.2. It is the parameter in the functions of AIM package.}

\item{backfit}{a logical argument indicating whether the existing cutpoints are adjusted after including new binary rule.}

\item{maxnumcut}{the maximum number of binary splits per predictor.}

\item{dirp}{a vector for pre-specified direction of the binary split for each of the predictors. 0 represents "no pre-given direction"; 1 represents "(x>cut)"; -1 represents "(x<cut)". Alternatively, "dirp=0" represents that there is no pre-given direction for any of the predictor.}
}
\value{
"cox.interaction" returns "maxsc", which is the observed partial likelihood score test statistics for the index*treatment interaction in the fitted model and "res", which is a list with components
}
\description{
Interaction Cox AIM
}
