% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SL.qda.R
\name{predict.SL.qda}
\alias{predict.SL.qda}
\title{Prediction wrapper for SL.qda}
\usage{
\method{predict}{SL.qda}(object, newdata, prior = object$object$prior,
  dimen = NULL, method = "plug-in", ...)
}
\arguments{
\item{object}{SL.lda object}

\item{newdata}{Dataframe to generate predictions}

\item{prior}{The prior probabilities of the classes, by default the
proportions in the training set or what was set in the call to lda.}

\item{dimen}{the dimension of the space to be used. If this is less than
min(p, ng-1), only the first dimen discriminant components are used (except
for method="predictive"), and only those dimensions are returned in x.}

\item{method}{This determines how the parameter estimation is handled. With
"plug-in" (the default) the usual unbiased parameter estimates are used and
assumed to be correct. With "debiased" an unbiased estimator of the log
posterior probabilities is used, and with "predictive" the parameter
estimates are integrated out using a vague prior.}

\item{...}{Unused additional arguments}
}
\description{
Prediction wrapper for SL.qda
}
\seealso{
\code{\link{SL.qda}} \code{\link[MASS]{qda}}
  \code{\link[MASS]{predict.qda}}
}
