# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Ordinary Least Squares
#' 
#' Fits the standard OLS model.
#' 
#' @param y Nx1 Numeric vector.
#' @param X NxP Numeric matrix.
#' 
#' @return List containing the following:
#' \item{Beta}{Regression coefficient.}
#' \item{V}{Outcome variance.}
#' \item{Ibb}{Information matrix for beta.}
#' \item{Resid}{Outcome residuals.}
fitOLS <- function(y, X) {
    .Call(`_SurrogateRegression_fitOLS`, y, X)
}

#' Matrix Determinant
#'
#' Calculates the determinant of \eqn{A}.
#'
#' @param A Numeric matrix.
#' @param logDet Return the logarithm of the determinant? 
#' @return Scalar. 
matDet <- function(A, logDet = FALSE) {
    .Call(`_SurrogateRegression_matDet`, A, logDet)
}

#' Matrix Inverse
#' 
#' Calcualtes \eqn{A^{-1}}.
#'
#' @param A Numeric matrix.
#' @return Numeric matrix. 
matInv <- function(A) {
    .Call(`_SurrogateRegression_matInv`, A)
}

#' Matrix Inner Product
#'
#' Calculates the product \eqn{A'B}.
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix.
matIP <- function(A, B) {
    .Call(`_SurrogateRegression_matIP`, A, B)
}

#' Matrix Matrix Product
#'
#' Calculates the product \eqn{AB}. 
#'
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix.
MMP <- function(A, B) {
    .Call(`_SurrogateRegression_MMP`, A, B)
}

#' Matrix Outer Product
#' 
#' Calculates the outer product \eqn{AB'}.
#' 
#' @param A Numeric matrix.
#' @param B Numeric matrix.
#' @return Numeric matrix.
matOP <- function(A, B) {
    .Call(`_SurrogateRegression_matOP`, A, B)
}

#' Quadratic Form
#' 
#' Calculates the quadratic form \eqn{X'AX}.
#' 
#' @param X Numeric matrix.
#' @param A Numeric matrix.
#' @return Numeric matrix.
matQF <- function(X, A) {
    .Call(`_SurrogateRegression_matQF`, X, A)
}

#' Schur complement
#'
#' Calculates the efficient information \eqn{I_{bb}-I_{ba}I_{aa}^{-1}I_{ab}}. 
#'
#' @param Ibb Information of target parameter
#' @param Iaa Information of nuisance parameter
#' @param Iba Cross information between target and nuisance parameters
#' @return Numeric matrix. 
SchurC <- function(Ibb, Iaa, Iba) {
    .Call(`_SurrogateRegression_SchurC`, Ibb, Iaa, Iba)
}

#' Matrix Trace
#'
#' Calculates the trace of a matrix \eqn{A}.
#'
#' @param A Numeric matrix.
#' @return Scalar.
tr <- function(A) {
    .Call(`_SurrogateRegression_tr`, A)
}

