% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_03_claim_notification.R
\name{claim_notification}
\alias{claim_notification}
\title{Claim Notification}
\usage{
claim_notification(
  frequency_vector,
  claim_size_list,
  mean_function,
  cv_function
)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{claim_size_list}{list of claim sizes.}

\item{mean_function}{target mean of the Weibull distribution as a function
of \code{claim_size} and \code{occurrence_period} (see Details for default
mean function).}

\item{cv_function}{target CoV (Coefficient of Variation) of the Weibull
distribution as a function of \code{claim_size} and \code{occurrence_period}
(see Details for default CoV function).}
}
\value{
A list of notification delays such that the \eqn{i}th component of
the list gives the notification delays for all claims that occurred in
period \eqn{i}.
}
\description{
Simulates and returns the notification/reporting delays of each of the
claims occurring in each of the periods, assuming a Weibull distribution.
}
\details{
Claim notification delay represents the delay from claim occurrence
to claim reporting. It is assumed that the notification delay follows a
Weibull distribution with parameters possibly dependent on claim size and
occurrence period. \cr \cr
By default, we assume that mean notification delay (in quarters) is given by
\deqn{min(3, max(1, 2-[log(claim_size/(0.50*ref_claim))]/3))}
automatically converted to the relevant \code{time_unit} defined by user at the
top of their script through \code{\link{set_parameters}}. Note that the
\code{ref_claim} in the equation is another package-wise global variable that the
user needs to define through \code{\link{set_parameters}} as it determines
the monetary scale of the simulator. The CoV (Coefficient of Variation)
of the notification delay is assumed to be constant at 70\%, independent of
the size and occurrence period of the claim.
}
\examples{
n_vector <- c(90, 79, 102, 78, 86, 88, 116, 84, 93, 104)

# Try constant mean/CoV function (i.e. independent of claim size)
notidel_mean <- function(claim_size, occurrence_period) {2}
notidel_cv <- function(claim_size, occurrence_period) {0.70}

notidel <- claim_notification(n_vector, claim_size(n_vector),
                              notidel_mean, notidel_cv)
notidel[[1]] # show notification for claims originating from period 1
}
