% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{coef.tandem}
\alias{coef.tandem}
\title{Returns the regression coefficients from a TANDEM fit}
\usage{
\method{coef}{tandem}(object, ...)
}
\arguments{
\item{object}{A tandem-object, as returned by tandem()}

\item{...}{Not used. Other arguments for coef().}
}
\value{
The regression coefficients.
}
\description{
Returns the regression coefficients from a TANDEM fit.
}
\examples{
# unpack example data
x = example_data$x
y = example_data$y
upstream = example_data$upstream

# fit a tandem model, determine the coefficients and create a prediction
fit = tandem(x, y, upstream, alpha=0.5)
beta = coef(fit)
y_hat = predict(fit, newx=x)
}

