% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{predict.tandem}
\alias{predict.tandem}
\title{Creates a prediction using a tandem-object}
\usage{
\method{predict}{tandem}(object, newx, ...)
}
\arguments{
\item{object}{A tandem-object, as returned by tandem()}

\item{newx}{A feature matrix, where the rows correspond to samples and the columns to features.}

\item{...}{Not used. Other arguments for predict().}
}
\value{
The predicted response vector.
}
\description{
Creates a prediction using a tandem-object.
}
\examples{
# unpack example data
x = example_data$x
y = example_data$y
upstream = example_data$upstream

# fit a tandem model, determine the coefficients and create a prediction
fit = tandem(x, y, upstream, alpha=0.5)
beta = coef(fit)
y_hat = predict(fit, newx=x)
}
