% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindHazaRds.R
\name{update_Track}
\alias{update_Track}
\title{Calculate Additional TC Parameters, and temporally Interpolate Along a Tropical Cyclone Track}
\usage{
update_Track(
  outdate = NULL,
  indate,
  TClons,
  TClats,
  vFms,
  thetaFms,
  cPs,
  rMaxModel,
  vMaxModel,
  betaModel,
  eP,
  rho = NULL
)
}
\arguments{
\item{outdate}{POSIX times to be interpolated to}

\item{indate}{POSIX input times}

\item{TClons}{input central TC longitude}

\item{TClats}{input central TC latitude}

\item{vFms}{input forward velocity of TC}

\item{thetaFms}{input forward direction}

\item{cPs}{central pressure}

\item{rMaxModel}{empirical model for radius of maximum wind calculation (rMax in km)}

\item{vMaxModel}{empirical model for maximum wind velocity calculation (vMax in m/s)}

\item{betaModel}{empirical model for TC shape parameter beta (dimensionless Beta)}

\item{eP}{background environmental pressure (hPa)}

\item{rho}{air density}
}
\value{
list of track data inclining the rMax vMax and Beta.
}
\description{
Calculate Additional TC Parameters, and temporally Interpolate Along a Tropical Cyclone Track
}
\examples{
paramsTable <- read.csv(system.file("extdata/tuningParams/defult_params.csv",package = "TCHazaRds"))
params <- array(paramsTable$value,dim = c(1,length(paramsTable$value)))
colnames(params) <- paramsTable$param
params <- data.frame(params)
require(terra)
TCi <- vect(system.file("extdata/YASI/YASI.shp", package="TCHazaRds"))
TCi$PRES <- TCi$BOM_PRES
t1 <- strptime("2011-02-01 09:00:00","\%Y-\%m-\%d \%H:\%M:\%S", tz = "UTC") #first date in POSIX format
t2 <- strptime(rev(TCi$ISO_TIME)[1],"\%Y-\%m-\%d \%H:\%M:\%S", tz = "UTC") #last date in POSIX format
outdate <- seq(t1,t2,"hour") #array sequence from t1 to t2 stepping by “hour”
TCil = update_Track(outdate = outdate,
                   indate = strptime(TCi$ISO_TIME,"\%Y-\%m-\%d \%H:\%M:\%S", tz = "UTC"),
                   TClons = TCi$LON,
                   TClats = TCi$LAT,
                   vFms=TCi$STORM_SPD,
                  thetaFms=TCi$thetaFm,
                   cPs=TCi$PRES,
                  rMaxModel=params$rMaxModel,
                   vMaxModel=params$vMaxModel,
                   betaModel=params$betaModel,
                   eP = params$eP,
                   rho = params$rhoa)

}
