% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_diag2landscape.R
\name{diag2landscape}
\alias{diag2landscape}
\title{Convert Persistence Diagram into Persistence Landscape}
\usage{
diag2landscape(homology, dimension = 1, k = 0, nseq = 1000)
}
\arguments{
\item{homology}{an object of S3 class \code{"homology"} generated from \code{diagRips} or other homology-generating functions.}

\item{dimension}{dimension of features to be considered (default: 1).}

\item{k}{the number of top landscape functions to be used (default: 0). When \code{k=0} is set, it gives all relevant landscape functions that are non-zero.}

\item{nseq}{grid size for which the landscape function is evaluated (default: 1000).}
}
\value{
a list object of \code{"landscape"} class containing\describe{
\item{lambda}{an \eqn{(\code{nseq} \times k)} landscape functions.}
\item{tseq}{a length-\code{nseq} vector of domain grid.}
\item{dimension}{dimension of features considered.}
}
}
\description{
Persistence Landscape (PL) is a functional summary of persistent homology 
that is constructed given a \code{homology} object.
}
\examples{
\donttest{
# ---------------------------------------------------------------------------
#              Persistence Landscape of 'iris' Dataset
#
# We will extract landscapes of dimensions 0, 1, and 2.
# For each feature, only the top 5 landscape functions are plotted.
# ---------------------------------------------------------------------------
## Prepare 'iris' data
XX = as.matrix(iris[,1:4])

## Compute Persistence Diagram 
pdrips = diagRips(XX, maxdim=2)

## Convert to Landscapes of Each Dimension
land0 <- diag2landscape(pdrips, dimension=0, k=5)
land1 <- diag2landscape(pdrips, dimension=1, k=5)
land2 <- diag2landscape(pdrips, dimension=2, k=5)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2))
plot(pdrips$Birth, pdrips$Death, col=as.factor(pdrips$Dimension),
     pch=19, main="persistence diagram", xlab="Birth", ylab="Death")
matplot(land0$tseq, land0$lambda, type="l", lwd=3, main="dimension 0", xlab="t")
matplot(land1$tseq, land1$lambda, type="l", lwd=3, main="dimension 1", xlab="t")
matplot(land2$tseq, land2$lambda, type="l", lwd=3, main="dimension 2", xlab="t")
par(opar)
}
}
\references{
Peter Bubenik (2018). ``The Persistence Landscape and Some of Its Properties.'' \emph{arXiv:1810.04963}.
}
\concept{convert}
