% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learn_mi_net_struct.R
\name{LearnClrNetFromDiscrData}
\alias{LearnClrNetFromDiscrData}
\title{Learns CLR network from a given discretized dataset.}
\usage{
LearnClrNetFromDiscrData(input.data.discr, num.nodes, node.names,
  num.timepts, max.fanin, output.dirname = "./OUTPUT")
}
\arguments{
\item{input.data.discr}{Discretized dataset}

\item{num.nodes}{number of nodes}

\item{node.names}{name of nodes}

\item{num.timepts}{number of timepoints}

\item{max.fanin}{number of top neighbours to retain}

\item{output.dirname}{output directory to store files}
}
\value{
mi network adjacency matrix
}
\description{
Learns CLR net from a given discretized dataset. For each node, retains top 'max.fanin' number of neighbours w.r.t. edge weight
and removes rest of the edges. Tie is broken in favour of the neighbour having smaller node index.
If there are less than that number of edges for a node, then retain all its neighbours.
}
