% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDB.R
\name{join_mdb_tables}
\alias{join_mdb_tables}
\title{Join connected tables}
\usage{
join_mdb_tables(
  x,
  ...,
  type = c("left", "right", "inner", "full"),
  jtName = NA
)
}
\arguments{
\item{x}{an MDB object}

\item{...}{at least 2 names of tables to join}

\item{type}{the type of join among:
\itemize{
\item \code{"left"}: includes all rows of the first provided table
\item \code{"right"}: includes all rows of the last provided table
\item \code{"inner"}: includes all rows in all provided tables
\item \code{"full"}: includes all rows in at least one provide table
}}

\item{jtName}{the name of the joint. IF NA (default), the name
is then the name is the first provided table name.}
}
\value{
A \link{metaMDB} corresponding to x with the
joined tables replaced by the joint.
If less than 2 table names are provided, the function returns
the original x MDB.
}
\description{
Join connected tables
}
