% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.TLMoments.R
\name{as.TLMoments}
\alias{as.TLMoments}
\alias{as.TLMoments.numeric}
\alias{as.TLMoments.matrix}
\alias{as.TLMoments.list}
\alias{as.TLMoments.data.frame}
\title{Convert to TLMoments-object}
\usage{
as.TLMoments(x, ..., leftrim, rightrim, ratios)

\method{as.TLMoments}{numeric}(x, leftrim = 0L, rightrim = 0L, ratios = FALSE, ...)

\method{as.TLMoments}{matrix}(x, leftrim = 0L, rightrim = 0L, ratios = FALSE, ...)

\method{as.TLMoments}{list}(x, leftrim = 0L, rightrim = 0L, ratios = FALSE, ...)

\method{as.TLMoments}{data.frame}(x, formula, leftrim = 0L, rightrim = 0L, ratios = FALSE, ...)
}
\arguments{
\item{x}{vector or matrix of TL-moments (or TL-moment ratios if ratios is TRUE) or a PWMs-object.
The first position or row is always used as the L1-moment, if vector or matrix are given.}

\item{...}{additional arguments.}

\item{leftrim, rightrim}{integer, order of trimmed L-moments.}

\item{ratios}{boolean, if TRUE the non-first positions or rows of x give
L-moment ratios, if FALSE (default) they give L-moments.
If ratios are used and the first position or row is NA, L1 is assumed to be 1!}

\item{formula}{if \code{x} is data.frame. See examples.}
}
\value{
object of class TLMoments, see PWMs help page.
}
\description{
Convert vector, matrix, list, or data.frame of TL-moments
or TL-moment ratios or a PWMs-object to a TLMoments-object in order
to be used with TLMoments-functions.
The first position of a vector or the first row of a matrix is
always used as the L1-moment. The \code{ratios} argument determines if the
following positions or rows are used as TL-moments oder TL-moments ratios.
The trimming has to be given using the \code{leftrim} and \code{rightrim} arguments.
}
\section{Methods (by class)}{
\itemize{
\item \code{numeric}: as.TLMoments for numeric data vectors

\item \code{matrix}: as.TLMoments for numeric data matrices

\item \code{list}: as.TLMoments for numeric data lists

\item \code{data.frame}: as.TLMoments for numeric data.frames
}}

\examples{
### Vector or matrix as input
xmat <- cbind(c(1, .2, .05), c(1, .2, NA), c(1.3, NA, .1))
xvec <- xmat[, 1]
xlist <- lapply(1:ncol(xmat), function(i) xmat[, i])
xdat <- data.frame(
 station = rep(letters[1:3], each = 1),
 season = c("S", "W", "S"),
 L1 = c(1, 1, 1.3),
 L2 = c(.2, .2, .3),
 L3 = c(.05, .04, .1)
)

as.TLMoments(xvec, rightrim = 1)
as.TLMoments(xmat, rightrim = 1)
as.TLMoments(xlist, rightrim = 1)
as.TLMoments(xdat, cbind(L1, L2, L3) ~ station)
as.TLMoments(xdat, .~station+season)
as.TLMoments(xdat, cbind(L1, L2, L3) ~ .)

parameters(as.TLMoments(xvec, rightrim = 0), "gev")
#lmomco::lmom2par(lmomco::vec2lmom(c(1, .2, .25)), "gev")$para

xmat <- cbind(c(NA, .2, -.05), c(NA, .2, .2))
xvec <- xmat[, 1]

as.TLMoments(xvec, ratios = TRUE)
as.TLMoments(xmat, ratios = TRUE)
parameters(as.TLMoments(xvec, ratios = TRUE), "gev")
#lmomco::lmom2par(lmomco::vec2lmom(c(1, .2, -.05)), "gev")$para

xmat <- cbind(c(10, .2, -.05), c(10, .2, .2))
xvec <- xmat[, 1]

as.TLMoments(xvec, ratios = TRUE)
as.TLMoments(xmat, ratios = TRUE)
parameters(as.TLMoments(xvec, ratios = TRUE), "gev")
#lmomco::lmom2par(lmomco::vec2lmom(c(10, .2, -.05)), "gev")$para

}
\seealso{
\code{\link{TLMoments}}
}
